//	CDialog3Button.c

#ifndef _H_CDialog3Button
#define _H_CDialog3Button

#include "CDialog.h"

#define		kDlog_ID_3Button	204

enum {
	kDlog_3Button_ItemID_NONE, 
	
	kDlog_3Button_ItemID_BUTTON_1, //	LEFT
	kDlog_3Button_ItemID_BUTTON_2, //	MIDDLE
	kDlog_3Button_ItemID_BUTTON_3, //	RIGHT
	kDlog_3Button_ItemID_ICON, 
	kDlog_3Button_ItemID_VERB, 
	
	kDlog_3Button_ItemID_NUMTYPES
};
//	typedef short	Dlog_ItemIDType;

enum {
	kDlog_3Button_ItemStr_BUTTON_1,
	kDlog_3Button_ItemStr_BUTTON_2,
	kDlog_3Button_ItemStr_BUTTON_3,
	kDlog_3Button_ItemStr_VERB,
	
	kDlog_3Button_ItemStr_NUMTYPES
};
//	typedef short	Dlog_ItemStrType;

typedef enum {
	Dlog_Action_NONE, 
	
	Dlog_Action_DEFAULT, 	//	return key
	Dlog_Action_CANCEL, 	//	esc, cmd-.
	Dlog_Action_DEFAULT_CANCEL,
	
	Dlog_Action_NUMTYPES
} Dlog_ActionType;

typedef struct {
	char				nameAC[32];
	short				buttonID;
	Dlog_ActionType		actionType;
	Boolean				visibleB;
	char				keyEquivChar;
} Dlog3ButtonRec;

typedef	Boolean	(*Dlog_3ButtonDoneCB)(short buttonID, void *cbData);

typedef struct {
	char				titleAC[64];
	char				verbageAC[256];
	Dlog_3ButtonDoneCB	DoneCB;
	void				*cbData;
	Dlog3ButtonRec		buttonA[3];
} Dlog3ButtonParamRec;

/***************************************/

class CDialog3Button;

CDialog3Button	*Show3ButtonDialog(
		Dlog3ButtonParamRec *dlogParamsP);
	
extern	CDialog3Button	*gCDialog3Button;

class CDialog3Button : public CDialog {

	public:		Boolean		IDialog3Button(
		Dlog3ButtonParamRec *dlogParamsP);

	virtual		void		Dispose(void);
	virtual		void		Finish(short buttonID);
	
	Dlog_ItemIDType			GetActionButton(Dlog_ActionType actionSeek);
	Dlog3ButtonRec			*GetButtonP(Dlog_ItemIDType itemID);
	Dlog_ItemIDType			GetKeyCharButton(char theKey);
	void					CopyButtonStr(Dlog_ItemIDType itemID);

	virtual		void		DoClick(EventRecord *event);
	virtual		void		DoKeyDown(EventRecord *event);
	virtual		void		Move(EventRecord *event);
	
	virtual		void		DialogItemStandardDrawProc(
		DialogItemIndex	itemNo,
		Rect			*itemRectP);

	void		ValueConvert(
		DGI_ValueConvertType	convertType, 
		short					dlgItem);

	virtual	void		UpdateMenus(void);
	virtual	Boolean		DoCommand(long command);
	
	/******************************************/
	DGI_ItemRec				i_itemStrTable[kDlog_3Button_ItemStr_NUMTYPES];
	Dlog3ButtonParamRec		i_paramRec;
	
	typedef		 	CDialog		_inherited;
};


#endif